rule Win64_Ransomware_DST : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DST"
        description         = "Yara rule that detects DST ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "DST"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            4C 8D A4 24 ?? ?? ?? ?? 4D 3B 66 ?? 0F 86 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 89 AC
            24 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ??
            ?? 48 89 BC 24 ?? ?? ?? ?? 44 0F 11 BC 24 ?? ?? ?? ?? 48 85 DB 0F 84 ?? ?? ?? ?? 48
            89 9C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 BC 24 ?? ?? ?? ?? 48 89 4C 24 ??
            31 C9 31 FF E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 85 DB
            0F 85 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 44 0F 11 BC 24 ?? ?? ?? ?? 48 8D 0D ?? ??
            ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ??
            ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 0F 1F 00
            E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 31 C0 48 8B 9C 24 ?? ?? ?? ?? 48 8B 8C 24 ??
            ?? ?? ?? 48 8D 3D ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BF ?? ??
            ?? ?? E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 85 DB 0F 85
            ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 44 0F 11 BC 24 ?? ?? ?? ?? 48 8D 0D
        }

        $encrypt_files_p2 = {
            48 89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 8D 8C 24
            ?? ?? ?? ?? 48 89 4C 24 ?? 48 8D 44 24 ?? E8 ?? ?? ?? ?? 90 85 C0 0F 85 ?? ?? ?? ??
            48 8D 05 ?? ?? ?? ?? BB ?? ?? ?? ?? 48 89 D9 E8 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ??
            BB ?? ?? ?? ?? 48 89 D9 E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ??
            ?? 48 85 DB 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? BB ?? ?? ?? ?? 48 89 D9 E8 ??
            ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 BC 24 ?? ?? ?? ?? 48 85 C9 0F 85 ?? ?? ?? ??
            48 89 5C 24 ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 8B 51 ?? 48 8B 84 24 ?? ??
            ?? ?? FF D2 48 8B 0D ?? ?? ?? ?? 83 B9 ?? ?? ?? ?? ?? 75 ?? 48 89 C2 48 C1 E0 ?? 48
            8D 70 ?? 48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 48 89 D1 48 F7 EE 48 8D 14 CA 48 8D 52 ?? 48
        }

        $encrypt_files_p3 = {
            C1 FA ?? 48 C1 FE ?? 48 29 F2 EB ?? 48 8D 70 ?? 48 89 C1 48 B8 ?? ?? ?? ?? ?? ?? ??
            ?? 48 F7 EE 48 8D 14 0A 48 8D 52 ?? 48 D1 FA 48 C1 FE ?? 48 29 F2 48 C1 E2 ?? 48 8D
            4A ?? 48 89 4C 24 ?? 48 8D 05 ?? ?? ?? ?? 48 89 CB E8 ?? ?? ?? ?? 48 89 C3 48 8B 4C
            24 ?? 48 89 CF 48 8B 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89
            8C 24 ?? ?? ?? ?? 48 85 DB 0F 85 ?? ?? ?? ?? 31 C0 48 8B 9C 24 ?? ?? ?? ?? 48 8B 4C
            24 ?? 48 8D 3D ?? ?? ?? ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 D9 48 89 C3 48 8B 84
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 85
            DB 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? BB ?? ?? ?? ?? 48 89 D9 31 FF 48 8B 74
            24 ?? 4C 8B 84 24 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 4C 8B 94 24 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 66 0F 1F 44 00 ?? 48 85 DB 0F
            85 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 C3 48 8D 0D ?? ?? ?? ?? 48 8B BC 24 ??
            ?? ?? ?? 31 F6 45 31 C0 4D 89 C1 48 8D 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 9C 24 ??
            ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 84 24
            ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 85 C0 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ??
            ?? 31 DB 31 C9 E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 85
            DB 74 ?? 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC
            24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 48 8B 94 24 ?? ?? ?? ?? 48 8B 72 ?? 48 8B 42
            ?? 48 8B 56 ?? 31 DB 31 C9 48 89 CF FF D2 48 8B 15 ?? ?? ?? ?? 48 89 CF 48 89 D9 48
        }

        $encrypt_files_p4 = {
            89 C3 48 89 D0 E8 ?? ?? ?? ?? 48 89 D9 48 89 C3 48 8B 84 24 ?? ?? ?? ?? 0F 1F 40 ??
            E8 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48
            8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ??
            ?? ?? C3 90 0F 1F 40 ?? E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ??
            ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84 24 ??
            ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90
            E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ??
            ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ??
            ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84
            24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ??
            C3 90 66 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC
            24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48
            8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ??
            ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4
            ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48
            8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ??
            ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 90 66 90
            E8 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ??
            ?? 48 81 C4 ?? ?? ?? ?? C3 48 89 44 24 ?? 48 89 5C 24 ?? 48 89 4C 24 ?? 48 89 7C 24
            ?? E8
        }

        $find_files_p1 = {
            4C 8D A4 24 ?? ?? ?? ?? 4D 3B 66 ?? 0F 86 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 89 AC
            24 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ??
            ?? 48 89 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 DB 7E ?? 48 89 5C 24 ?? 31 C9 EB ??
            48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 48 8B 9C 24 ?? ?? ?? ?? 48 8D 43 ??
            48 89 4C 24 ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 10 48 89 54 24 ?? 48 8B 58 ?? 48 89 5C
            24 ?? 48 8B 72 ?? 48 89 D8 FF D6 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48
            8B 8C 24 ?? ?? ?? ?? 48 8D 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 49 89 C0 49 89 D9 31 C0 48
            8B 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 ?? 48 89 5C 24 ?? 48 8B 4C 24 ?? 48
            8B 51 ?? 48 8B 44 24 ?? FF D2 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 8D
            4B ?? 66 90 E9 ?? ?? ?? ?? 48 29 CB 48 89 DA 48 F7 DB 48 C1 FB ?? 48 21 D9 48 01 C1
            48 89 8C 24 ?? ?? ?? ?? 48 89 94 24 ?? ?? ?? ?? EB ?? 31 D2 31 C9 48 89 C8 48 89 D3
            E8 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ??
            48 8B 3D ?? ?? ?? ?? 48 8B 35 ?? ?? ?? ?? 66 90 E8 ?? ?? ?? ?? 84 C0 74 ?? 48 8D BC
            24 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? 0F 1F 84 00 ?? ?? ?? ?? 48 89 6C 24 ?? 48 8D 6C
        }

        $find_files_p2 = {
            24 ?? E8 ?? ?? ?? ?? 48 8B 6D ?? 48 8D 84 24 ?? ?? ?? ?? 31 C9 0F 1F 00 E9 ?? ?? ??
            ?? 48 8B 4C 24 ?? 48 8B 49 ?? 48 8B 44 24 ?? FF D1 84 C0 74 ?? 48 8B 44 24 ?? 48 8B
            5C 24 ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 FF C1 48 8B 54 24
            ?? 0F 1F 00 48 39 CA 0F 8F ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 FF C9 48 85 C9 0F 8C ?? ??
            ?? ?? 0F B6 14 08 66 90 80 FA ?? 0F 84 ?? ?? ?? ?? 80 FA ?? 0F 84 ?? ?? ?? ?? 80 FA
            ?? 75 ?? E9 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8D 42 ?? 48 89 4C 24 ?? 48 89 84
            24 ?? ?? ?? ?? 48 8B 10 48 89 54 24 ?? 48 8B 70 ?? 48 89 74 24 ?? 48 8B 5C 24 ?? 48
            8B 44 24 ?? E8 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 8B 44
            24 ?? 48 8B 5C 24 ?? E8 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ??
            48 89 DF 48 89 D3 48 89 C2 48 89 C8 48 89 D1 E8 ?? ?? ?? ?? 0F 1F 84 00 ?? ?? ?? ??
            48 85 C0 0F 8D ?? ?? ?? ?? 48 8B 4C 24 ?? 48 FF C1 48 83 F9 ?? 0F 8C ?? ?? ?? ?? 48
            8B 4C 24 ?? 48 89 8C 24 ?? ?? ?? ?? 48 8B 54 24 ?? 48 89 94 24 ?? ?? ?? ?? 48 8B 84
            24 ?? ?? ?? ?? 48 8D 9C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 89 44 24 ??
            48 89 5C 24 ?? 48 89 4C 24 ?? 66 90 E8
        }

        $kill_procs_p1 = {
            4C 8D A4 24 ?? ?? ?? ?? 4D 3B 66 ?? 0F 86 ?? ?? ?? ?? 48 81 EC ?? ?? ?? ?? 48 89 AC
            24 ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48
            89 5C 24 ?? 31 C9 66 90 EB ?? 48 8B 54 24 ?? 48 8D 4A ?? 48 8B 84 24 ?? ?? ?? ?? 48
            8B 5C 24 ?? 0F 1F 84 00 ?? ?? ?? ?? 48 39 CB 0F 8E ?? ?? ?? ?? 48 89 4C 24 ?? 48 C1
            E1 ?? 48 8B 1C 08 48 89 5C 24 ?? 48 8B 4C 08 ?? 48 89 4C 24 ?? 48 8B 73 ?? 48 89 C8
            FF D6 48 89 1D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 ?? 48 89 05 ?? ?? ?? ?? EB ?? 48
            8D 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 8B 49 ?? 48 8B 44 24 ?? FF D1 48
            89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8B
            3D ?? ?? ?? ?? 48 89 C3 48 8D 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48
            89 08 48 8D BC 24 ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? F3 48 A5 48 8D BC
            24 ?? ?? ?? ?? 48 8D 7F ?? 48 89 6C 24 ?? 48 8D 6C 24 ?? E8 ?? ?? ?? ?? 48 8B 6D ??
            48 8D 05 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ??
            EB ?? 48 8B AC 24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? C3 48 8D 84 24 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? 66 0F 1F 84 00 ?? ?? 00 00 48 85 C9 0F 84 ?? ?? ??
            ?? 48 8B 94 24 ?? ?? ?? ?? 48 8B 12 48 89 54 24 ?? 48 8B 01 48 89 44 24 ?? 48 8B 59
            ?? 48 89 5C 24 ?? 48 8D 8C 24 ?? ?? ?? ?? 31 F6 EB ?? 48 8B 94 24 ?? ?? ?? ?? 48 83
        }

        $kill_procs_p2 = {
            C2 ?? 48 8B 44 24 ?? 48 8B 5C 24 ?? 48 89 CE 48 89 D1 48 89 74 24 ?? 48 89 8C 24 ??
            ?? ?? ?? 48 8B 11 48 89 54 24 ?? 48 8B 79 ?? 48 89 7C 24 ?? E8 ?? ?? ?? ?? 48 8B 4C
            24 ?? 48 8B 7C 24 ?? 90 E8 ?? ?? ?? ?? 48 85 C0 0F 8C ?? ?? ?? ?? 48 8B 44 24 ?? BB
            ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 89 C7 48 89 DE 31 C0 48 8D 1D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 44 0F 11 39 48 8D 94 24 ?? ?? ?? ?? 44 0F
            11 3A 48 8D 15 ?? ?? ?? ?? 48 89 94 24 ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ?? ?? ??
            ?? 48 89 84 24 ?? ?? ?? ?? 48 89 9C 24 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? BB ?? ?? ??
            ?? BF ?? ?? ?? ?? 48 89 FE E8 ?? ?? ?? ?? 48 89 44 24 ?? 44 0F 11 BC 24 ?? ?? ?? ??
            48 8D 0D ?? ?? ?? ?? 48 89 8C 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8B 1D ?? ??
            ?? ?? BF ?? ?? ?? ?? 48 89 FE 48 8D 05 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 48 8B 44 24 ?? 90 E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 FF C1 48 83 F9 ?? 0F 8C ??
            ?? ?? ?? E9 ?? ?? ?? ?? 0F 1F 40 ?? E8
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($kill_procs_p*)
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}